<?php
use Elementor\Controls_Manager;

class TS_Elementor_Widget_Mailchimp extends TS_Elementor_Widget_Base{
	public function get_name(){
        return 'ts-mailchimp';
    }
	
	public function get_title(){
        return esc_html__( 'TS Mailchimp', 'themesky' );
    }
	
	public function get_categories(){
        return array( 'ts-elements', 'general' );
    }
	
	public function get_icon(){
		return 'eicon-email-field';
	}
	
	protected function register_controls(){
		$this->start_controls_section(
            'section_general'
            ,array(
                'label' 	=> esc_html__( 'General', 'themesky' )
                ,'tab'   	=> Controls_Manager::TAB_CONTENT
            )
        );
		
		$this->add_control(
            'form'
            ,array(
                'label' 		=> esc_html__( 'Form', 'themesky' )
                ,'type' 		=> Controls_Manager::SELECT
                ,'default' 		=> ''
				,'options'		=> $this->get_custom_post_options( 'mc4wp-form' )			
                ,'description' 	=> ''
            )
        );
		
		$this->add_control(
            'style'
            ,array(
                'label' 		=> esc_html__( 'Style', 'themesky' )
                ,'type' 		=> Controls_Manager::SELECT
                ,'default' 		=> 'style-button-text'
				,'options'		=> array(
									'style-button-text'			=> esc_html__( 'Style Button Text', 'themesky' )
									,'style-button-icon'		=> esc_html__( 'Style Button Icon', 'themesky' )
								)			
                ,'description' 	=> ''
            )
        );
		
		$this->add_control(
            'title'
            ,array(
                'label' 		=> esc_html__( 'Title', 'themesky' )
                ,'type' 		=> Controls_Manager::TEXTAREA
                ,'default' 		=> ''		
                ,'description' 	=> ''
            )
        );

		$this->add_control(
            'intro_text'
            ,array(
                'label' 		=> esc_html__( 'Intro text', 'themesky' )
                ,'type' 		=> Controls_Manager::TEXTAREA
                ,'default' 		=> ''		
                ,'description' 	=> ''
            )
        );

		$this->add_responsive_control(
			'title_size',
			[
				'label' => __( 'Font Size Title(px)', 'themesky' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 36,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 26,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 20,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .mailchimp-subscription .widget-title' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'intro_text_size',
			[
				'label' => __( 'Font Size Intro text(px)', 'themesky' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 14,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 14,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 14,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .mailchimp-subscription .newsletter' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
            'text_align'
            ,array(
                'label' 		=> esc_html__( 'Text Align', 'themesky' )
                ,'type' 		=> Controls_Manager::SELECT
                ,'default' 		=> 'text-left'
				,'options'		=> array(
									'text-left'			=> esc_html__( 'Left', 'themesky' )
									,'text-center'		=> esc_html__( 'Center', 'themesky' )
									,'text-right'		=> esc_html__( 'Right', 'themesky' )
								)			
                ,'description' 	=> ''
            )
        );
		
		$this->add_control(
            'input_size'
            ,array(
                'label' 		=> esc_html__( 'Input Size', 'themesky' )
                ,'type' 		=> Controls_Manager::SELECT
                ,'default' 		=> 'size-small'
				,'options'		=> array(
									'size-small'		=> esc_html__( 'Default', 'themesky' )
									,'size-large'		=> esc_html__( 'Large', 'themesky' )
								)			
                ,'description' 	=> ''
            )
        );
		
		$this->add_control(
            'color_style'
            ,array(
                'label' 		=> esc_html__( 'Color Style', 'themesky' )
                ,'type' 		=> Controls_Manager::SELECT
                ,'default' 		=> 'default'
				,'options'		=> array(
									'default'		=> esc_html__( 'Default', 'themesky' )
									,'custom'		=> esc_html__( 'Custom', 'themesky' )
								)			
                ,'description' 	=> ''
            )
        );
		
		$this->add_control(
            'text_color'
            ,array(
                'label'     	=> esc_html__( 'Text Color', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#202020'
				,'selectors'	=> array(
					'{{WRAPPER}} .mailchimp-subscription .widget-title' => 'color: {{VALUE}}'
					,'{{WRAPPER}} .mailchimp-subscription .newsletter' => 'color: {{VALUE}}'
				)
				,'condition'	=> array( 'color_style' => 'custom' )
            )
        );
		
		$this->add_control(
            'input_bg_color'
            ,array(
                'label'     	=> esc_html__( 'Input Background Color', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#ffffff'
				,'selectors'	=> array(
					'{{WRAPPER}} .subscribe-email input[type="email"]' => 'background: {{VALUE}}'
				)
				,'condition'	=> array( 'color_style' => 'custom' )
            )
        );
		
		$this->add_control(
            'input_border_color'
            ,array(
                'label'     	=> esc_html__( 'Input Border Color', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#e6e6e6'
				,'selectors'	=> array(
					'{{WRAPPER}} .subscribe-email input[type="email"]' => 'border-color: {{VALUE}}'
				)
				,'condition'	=> array( 'color_style' => 'custom' )
            )
        );
		
		$this->add_control(
            'input_text_color'
            ,array(
                'label'     	=> esc_html__( 'Input Text Color', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#202020'
				,'selectors'	=> array(
					'{{WRAPPER}} .subscribe-email input[type="email"]' => 'color: {{VALUE}}'
					,'{{WRAPPER}} .subscribe-email input[type="email"]::-webkit-input-placeholder' => 'color: {{VALUE}}'
					,'{{WRAPPER}} .subscribe-email input[type="email"]::-moz-placeholder' => 'color: {{VALUE}}'
					,'{{WRAPPER}} .subscribe-email input[type="email"]::-ms-input-placeholder' => 'color: {{VALUE}}'
				)
				,'condition'	=> array( 'color_style' => 'custom' )
            )
        );
		
		$this->add_control(
            'button_bg_color'
            ,array(
                'label'     	=> esc_html__( 'Button Background Color', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#ffb91f'
				,'selectors'	=> array(
					'{{WRAPPER}} .subscribe-email .button' => 'background: {{VALUE}}'
					,'{{WRAPPER}} .subscribe-email .button:hover' => 'color: {{VALUE}}; border-color: {{VALUE}}'
				)
				,'condition'	=> array( 'color_style' => 'custom' )
            )
        );
		
		$this->add_control(
            'button_border_color'
            ,array(
                'label'     	=> esc_html__( 'Button Border Color', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#ffb91f'
				,'selectors'	=> array(
					'{{WRAPPER}} .subscribe-email .button' => 'border-color: {{VALUE}}'
				)
				,'condition'	=> array( 'color_style' => 'custom' )
            )
        );
		
		$this->add_control(
            'button_text_color'
            ,array(
                'label'     	=> esc_html__( 'Button Text Color', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#202020'
				,'selectors'	=> array(
					'{{WRAPPER}} .subscribe-email .button' => 'color: {{VALUE}}'
				)
				,'condition'	=> array( 'color_style' => 'custom' )
            )
        );
		
		$this->end_controls_section();
	}
	
	protected function render(){
		$settings = $this->get_settings_for_display();
		
		$default = array(
			'title'				=> ''
			,'intro_text'		=> ''
			,'form'				=> ''
			,'style'			=> 'style-button-text'
			,'text_align'		=> 'text-left'
			,'input_size'		=> 'size-small'
		);
		
		$settings = wp_parse_args( $settings, $default );
		
		extract( $settings );
		
		if( !class_exists('TS_Mailchimp_Subscription_Widget') ){
			return;
		}
		
		$intro_html = '';
		if( $intro_text ){
			$intro_html = '<div class="newsletter"><p>'.esc_html($intro_text).'</p></div>';
			$intro_text = '';
		}
		
		$args = array(
			'before_widget' => '<section class="widget-container %s">'
			,'after_widget' => '</section>'
			,'before_title' => '<div class="widget-title-wrapper"><h3 class="widget-title heading-title">'
			,'after_title'  => '</h3>'.$intro_html.'</div>'
		);

		$title = wp_kses($title, array('br' => array()));
		$instance = compact('title', 'intro_text', 'form');
		
		$classes = array();
		$classes[] = $style;
		$classes[] = $text_align;
		$classes[] = $input_size;
		
		if($color_style == 'custom'){
			$classes[] = 'custom-color';
		}
		
		echo '<div class="ts-mailchimp-subscription-shortcode '.implode(' ', $classes).'" >';
		
		the_widget('TS_Mailchimp_Subscription_Widget', $instance, $args);
		
		echo '</div>';
	}
}

$widgets_manager->register_widget_type( new TS_Elementor_Widget_Mailchimp() );