jQuery(function($){
	"use strict";
	
	ts_register_carousel( null, $ );
	
	/*** Load Products In Category Tab ***/
	var ts_product_in_category_tab_data = [];
	
	/* Change tab */
	$('.ts-product-in-category-tab-wrapper .column-tabs .tab-item, .ts-product-in-product-type-tab-wrapper .column-tabs .tab-item').on('click', function(){
		var element = $(this).parents('.ts-product-in-category-tab-wrapper');
		var is_product_type_tab = false;
		if( element.length == 0 ){
			element = $(this).parents('.ts-product-in-product-type-tab-wrapper');
			is_product_type_tab = true;
		}
		
		var element_top = element.offset().top;
		if( element_top > $(window).scrollTop() ){
			var admin_bar_height = $('#wpadminbar').length > 0?$('#wpadminbar').outerHeight():0;
			var sticky_height = $('.is-sticky .header-sticky').length > 0?$('.is-sticky .header-sticky').outerHeight():0;
			$('body, html').animate({
				scrollTop: element_top - sticky_height - admin_bar_height - 20
			}, 500);
		}
		
		if( $(this).hasClass('current') || element.find('.column-products').hasClass('loading') ){
			return;
		}
		
		element.removeClass('generated-slider');
		
		var element_id = element.attr('id');
		var atts = element.data('atts');
		if( !is_product_type_tab ){
			var product_cat = $(this).data('product_cat');
			var shop_more_link = $(this).data('link');
			var is_general_tab = $(this).hasClass('general-tab')?1:0;
		}
		else{
			var product_cat = atts.product_cats;
			var is_general_tab = 0;
			atts.product_type = $(this).data('product_type');
			element.find('.column-products').removeClass('recent sale featured best_selling top_rated mixed_order').addClass(atts.product_type);
		}
		
		if( !is_product_type_tab && element.find('a.shop-more-button').length > 0 ){
			element.find('a.shop-more-button').attr('href', shop_more_link);
		}
		
		element.find('.column-tabs .tab-item').removeClass('current');
		$(this).addClass('current');
		
		/* Check cache */
		var tab_data_index = element_id + '-' + product_cat.toString().split(',').join('-');
		if( is_product_type_tab ){
			tab_data_index += '-' + atts.product_type;
		}
		if( ts_product_in_category_tab_data[tab_data_index] != undefined ){
			element.find('.column-products .products').remove();
			element.find('.column-products').append( ts_product_in_category_tab_data[tab_data_index] ).hide().fadeIn(600);
			
			/* Shop more button handle */
			if( !is_product_type_tab ){
				ts_product_in_category_tab_shop_more_handle( element, atts );
			}
			
			/* Generate slider */
			ts_register_carousel( element.parent(), $ );
			
			return;
		}
		
		element.find('.column-products').addClass('loading');
		
		$.ajax({
			type : "POST",
			timeout : 30000,
			url : themesky_params.ajax_uri,
			data : {action: 'ts_get_product_content_in_category_tab', atts: atts, product_cat: product_cat, is_general_tab: is_general_tab},
			error: function(xhr,err){
				
			},
			success: function(response) {
				if( response ){
					element.find('.column-products .products').remove();
					element.find('.column-products').append( response ).hide().fadeIn(600);
					/* save cache */
					if( element.find('.counter-wrapper').length == 0 ){
						ts_product_in_category_tab_data[tab_data_index] = response;
					}
					else{
						ts_counter( element.find('.counter-wrapper') );
					}
					/* Shop more button handle */
					if( !is_product_type_tab ){
						ts_product_in_category_tab_shop_more_handle( element, atts );
					}
					/* Generate slider */
					ts_register_carousel( element.parent(), $ );
				}
				element.find('.column-products').removeClass('loading');
			}
		});
	});
	
	function ts_product_in_category_tab_shop_more_handle(element, atts){
		var hide_shop_more = element.find('.hide-shop-more').length;
		element.find('.hide-shop-more').remove();

		if( element.find('.tab-item.current').hasClass('general-tab') && atts.show_shop_more_general_tab == 0 ){
			hide_shop_more = true;
		}

		if( element.find('.products .product').length == 0 ){
			hide_shop_more = true;
		}

		if( atts.show_shop_more_button == 1 ){
			if( hide_shop_more ){
				element.find('.shop-more').addClass('hidden');
				element.removeClass('has-shop-more-button');
			}
			else {
				element.find('.shop-more').removeClass('hidden');
				element.addClass('has-shop-more-button');
			}
		}
	}
	
	$('.ts-product-in-category-tab-wrapper').each(function(){
		var element = $(this);
		var atts = element.data('atts');
		ts_product_in_category_tab_shop_more_handle( element, atts );
	});
	
	setTimeout(function(){
		/*** Blog Shortcode ***/
		$('.ts-blogs-wrapper.ts-shortcode').each(function(){
			var element = $(this);
			var atts = element.data('atts');
			
			var is_masonry = typeof $.fn.isotope == 'function' && element.hasClass('ts-masonry') ? true : false;
			
			/* Show more */
			element.find('a.load-more').on('click', function(){
				var button = $(this);
				if( button.hasClass('loading') ){
					return false;
				}
				
				button.addClass('loading');
				var paged = button.attr('data-paged');
				var total_pages = button.attr('data-total_pages');
				
				$.ajax({
					type : "POST",
					timeout : 30000,
					url : themesky_params.ajax_uri,
					data : {action: 'ts_blogs_load_items', paged: paged, atts : atts},
					error: function(xhr,err){
						
					},
					success: function(response) {
						if( paged == total_pages ){
							button.parent().remove();
						}
						else{
							button.removeClass('loading');
							button.attr('data-paged', ++paged);
						}
						if( response != 0 && response != '' ){
							if( is_masonry ){										
								element.find('.blogs').isotope('insert', $(response));
								setTimeout(function(){
									element.find('.blogs').isotope('layout');
								}, 500);
							}
							else{
								element.find('.blogs').append(response);
							}
							
							ts_register_carousel( element.parent(), $ );
						}
						else{ /* No results */
							button.parent().remove();
						}
					}
				});
				
				return false;
			});
		});
		
	}, 200);
	
	/*** Counter ***/
	function ts_counter( elements ){
		if( elements.length > 0 ){
			var interval = setInterval(function(){
				elements.each(function(index, element){
					var wrapper = jQuery(element);
					var second = parseInt( wrapper.find('.seconds .number').text() );
					if( second > 0 ){
						second--;
						second = ( second < 10 )? zeroise(second, 2) : second.toString();
						wrapper.find('.seconds .number').text(second);
						return;
					}
					
					var delta = 0;
					var time_day = 60 * 60 * 24;
					var time_hour = 60 * 60;
					var time_minute = 60;
					
					var day = parseInt( wrapper.find('.days .number').text() );
					var hour = parseInt( wrapper.find('.hours .number').text() );
					var minute = parseInt( wrapper.find('.minutes .number').text() );
					
					if( day != 0 || hour != 0  || minute != 0 || second != 0 ){
						delta = (day * time_day) + (hour * time_hour) + (minute * time_minute) + second;
						delta--;
						
						day = Math.floor(delta / time_day);
						delta -= day * time_day;
						
						hour = Math.floor(delta / time_hour);
						delta -= hour * time_hour;
						
						minute = Math.floor(delta / time_minute);
						delta -= minute * time_minute;
						
						second = delta > 0?delta:0;
						
						day = ( day < 10 )? zeroise(day, 2) : day.toString();
						hour = ( hour < 10 )? zeroise(hour, 2) : hour.toString();
						minute = ( minute < 10 )? zeroise(minute, 2) : minute.toString();
						second = ( second < 10 )? zeroise(second, 2) : second.toString();
						
						wrapper.find('.days .number').text(day);
						wrapper.find('.hours .number').text(hour);
						wrapper.find('.minutes .number').text(minute);
						wrapper.find('.seconds .number').text(second);
					}
				});
			}, 1000);
		}
	}
	
	ts_counter( $('.product .counter-wrapper, .ts-countdown .counter-wrapper') );
	
	/*** Portfolio load more ***/
	$('.ts-portfolio-wrapper .load-more').on('click', function(){
		var element = $(this).parents('.ts-portfolio-wrapper');

		var atts = element.data('atts');
		var button = $(this);
		if( button.hasClass('loading') ){
			return false;
		}

		button.addClass('loading');
		var paged = button.attr('data-paged');
		var total_pages = button.attr('data-total_pages');

		$.ajax({
			type: "POST",
			timeout: 30000,
			url: themesky_params.ajax_uri,
			data: { action: 'ts_portfolio_load_items', paged: paged, atts: atts },
			error: function(xhr, err) {

			},
			success: function(response) {
				if( paged == total_pages ){
					button.parent().remove();
				} else {
					button.removeClass('loading');
					button.attr('data-paged', ++paged);
				}

				if( response != 0 && response != '' ){
					var selector = element.find('.portfolio-wrapper-content');
					if( typeof $.fn.isotope == 'function'){
						selector.isotope('insert', $(response));
						element.find('.filter-bar li.current').trigger('click');
						setTimeout(function(){
							selector.isotope('layout');
						}, 500);
					}
				}
				else { /* No results */
					button.parent().remove();
				}
			}
		});

		return false;
	});
	
	/* Porfolio filter bar */
	$(document).on('click', '.ts-portfolio-wrapper .filter-bar li', function(){
		$(this).siblings('li').removeClass('current');
		$(this).addClass('current');

		var element = $(this).parents('.ts-portfolio-wrapper');
		var data_filter = $(this).data('filter');
		
		element.find('.portfolio-wrapper-content').isotope({ filter: data_filter });
	});
	
	/* Update like */
	$(document).on('click', '.ts-portfolio-wrapper .like, .single-portfolio .portfolio-like', function(e){
		if( $(this).hasClass('portfolio-like') ){
			var _this = $(this).find('.ic-like');
		} else {
			var _this = $(this);
		}

		if( _this.hasClass('loading') ){
			return false;
		}
		_this.addClass('loading');
		
		var already_like = _this.hasClass('already-like');
		var is_single = _this.hasClass('ic-like');
		
		var post_id = _this.data('post_id');
		$.ajax({
			type : "POST",
			timeout : 30000,
			url : themesky_params.ajax_uri,
			data : {action: 'ts_portfolio_update_like', post_id: post_id},
			error: function(xhr,err){
				_this.removeClass('loading');
			},
			success: function(response) {
				if( response != '' ){
					if( already_like ){
						_this.removeClass('already-like');
						if( !is_single ){
							_this.attr('title', _this.data('like-title'));
						}
					}
					else{
						_this.addClass('already-like');
						if( !is_single ){
							_this.attr('title', _this.data('liked-title'));
						}
					}
					if( is_single ){
						var single_plural = '1' == response ? 'single' : 'plural';
						response += ' ' + _this.siblings('.like-num').data(single_plural);
						_this.siblings('.like-num').text(response);
					}
				}
				_this.removeClass('loading');
			}
		});
		
		return false;
	});
	
	/*** Widgets ***/
	/* Custom WP Widget Categories Dropdown */
	$('.widget_categories > ul').each(function(index, ele){
		var _this = $(ele);
		var icon_toggle_html = '<span class="icon-toggle"></span>';
		var ul_child = _this.find('ul.children');
		ul_child.hide();
		ul_child.closest('li').addClass('cat-parent');
		ul_child.before( icon_toggle_html );
	});
	
	$('.widget_categories span.icon-toggle').on('click', function(){
		var parent_li = $(this).parent('li.cat-parent');
		if( !parent_li.hasClass('active') ){
			parent_li.find('ul.children:first').slideDown();
			parent_li.addClass('active');
		}
		else{
			parent_li.find('ul.children').slideUp();
			parent_li.removeClass('active');
			parent_li.find('li.cat-parent').removeClass('active');
		}
	});
	
	$('.widget_categories li.current-cat').parents('ul.children').siblings('.icon-toggle').trigger('click');
	$('.widget_categories li.current-cat.cat-parent > .icon-toggle').trigger('click');
	
	/* Product Categories widget */
	$('.ts-product-categories-widget .icon-toggle').on('click', function(){
		var parent_li = $(this).parent('li.cat-parent');
		if( !parent_li.hasClass('active') ){
			parent_li.addClass('active');
			parent_li.find('ul.children:first').slideDown();
		}
		else{
			parent_li.find('ul.children').slideUp();
			parent_li.removeClass('active');
			parent_li.find('li.cat-parent').removeClass('active');
		}
	});
	
	$('.ts-product-categories-widget').each(function(){
		var element = $(this);
		element.find('ul.children').parent('li').addClass('cat-parent');
		element.find('li.current.cat-parent > .icon-toggle').trigger('click');
		element.find('li.current').parents('ul.children').siblings('.icon-toggle').trigger('click');
	});
	
	/* Product Filter By Availability */
	$('.product-filter-by-availability-wrapper > ul input[type="checkbox"]').on('change', function(){
		$(this).parent('li').siblings('li').find('input[type="checkbox"]').attr('checked', false);
		var val = '';
		if( $(this).is(':checked') ){
			val = $(this).val();
		}
		var form = $(this).closest('ul').siblings('form');
		if( val != '' ){
			form.find('input[name="stock"]').val(val);
		}
		else{
			form.find('input[name="stock"]').remove();
		}
		form.submit();
	});

	/* Product Filter By Brand */
	$('.product-filter-by-brand-wrapper ul input[type="checkbox"]').on('change', function(){
		var wrapper = $(this).parents('.product-filter-by-brand-wrapper');
		var query_type = wrapper.find('> .query-type').val();
		var checked = $(this).is(':checked');
		var val = new Array();
		if( query_type == 'or' ){
			wrapper.find('ul input[type="checkbox"]').attr('checked', false);
			if( checked ){
				$(this).off('change');
				$(this).attr('checked', true);
				val.push( $(this).val() );
			}
		}
		else{
			wrapper.find('ul input[type="checkbox"]:checked').each(function(index, ele){
				val.push( $(ele).val() );
			});
		}
		val = val.join(',');
		var form = wrapper.find('form');
		if( val != '' ){
			form.find('input[name="product_brand"]').val( val );
		}
		else{
			form.find('input[name="product_brand"]').remove();
		}
		form.submit();
	});
});

function zeroise( str, max ){
	str = str.toString();
	return str.length < max ? zeroise('0' + str, max) : str;
}

class TS_Carousel{
	register( $scope, $ ){
		var carousel = this;

		/* [wrapper selector, slider selector, slider options (remove dynamic columns at last)] */
		var data = [
			['.ts-product-wrapper.grid', '.products', { breakpoints:{0:{slidesPerView:1},305:{slidesPerView:2},615:{slidesPerView:3},1000:{slidesPerView:4}} }]
			,['.ts-product-wrapper.list', '.products', { breakpoints:{0:{slidesPerView:1},600:{slidesPerView:2},1100:{slidesPerView:3}} }]
			,['.ts-product-in-category-tab-wrapper.grid, .ts-product-in-product-type-tab-wrapper.grid', '.products', { breakpoints:{0:{slidesPerView:1},305:{slidesPerView:2},615:{slidesPerView:3},1000:{slidesPerView:4}} }]
			,['.ts-product-in-category-tab-wrapper.list, .ts-product-in-product-type-tab-wrapper.list', '.products', { breakpoints:{0:{slidesPerView:1},600:{slidesPerView:2},1100:{slidesPerView:3}} }]
			,['.ts-product-deals-wrapper.grid', '.products', { breakpoints:{0:{slidesPerView:1},305:{slidesPerView:2},615:{slidesPerView:3},1000:{slidesPerView:4}} }]
			,['.ts-product-deals-wrapper.list', '.products', { breakpoints:{0:{slidesPerView:1},600:{slidesPerView:2},1100:{slidesPerView:3}} }]
			,['.ts-product-category-wrapper.style-1', '.products', { breakpoints:{0:{slidesPerView:1},300:{slidesPerView:2},450:{slidesPerView:3},600:{slidesPerView:4},750:{slidesPerView:5},1000:{slidesPerView:6},1090:{slidesPerView:7}} }]
			,['.ts-product-category-wrapper.style-2', '.products', { breakpoints:{0:{slidesPerView:1},320:{slidesPerView:2},720:{slidesPerView:3},960:{slidesPerView:4},1200:{slidesPerView:5}} }]
			,['.ts-product-category-wrapper.style-3', '.products', { breakpoints:{0:{slidesPerView:1},600:{slidesPerView:2},900:{slidesPerView:3},1200:{slidesPerView:4}} }]
			,['.ts-product-category-wrapper.show-icon', '.products', { breakpoints:{0:{slidesPerView:1},260:{slidesPerView:2},340:{slidesPerView:3},480:{slidesPerView:4},600:{slidesPerView:5},840:{slidesPerView:6},980:{slidesPerView:7},1120:{slidesPerView:8},1200:{slidesPerView:9}} }]
			,['.ts-product-brand-wrapper', '.content-wrapper', { breakpoints:{0:{slidesPerView:1},320:{slidesPerView:2},600:{slidesPerView:3},800:{slidesPerView:4},1100:{slidesPerView:5}} }]
			,['.ts-products-widget-wrapper', null, { spaceBetween: 10, breakpoints:{0:{slidesPerView:1}} }]
			,['.ts-blogs-wrapper', '.blogs', { breakpoints:{0:{slidesPerView:1},760:{slidesPerView:2},1200:{slidesPerView:3}} }]
			,['.ts-logo-slider-wrapper', '.items', { breakpoints:{0:{slidesPerView:1},280:{slidesPerView:2},540:{slidesPerView:3},700:{slidesPerView:4},900:{slidesPerView:5},1100:{slidesPerView:6},1400:{slidesPerView:7},1600:{slidesPerView:8}} }]
			,['.ts-team-members', '.items', { breakpoints:{0:{slidesPerView:1},300:{slidesPerView:2},620:{slidesPerView:3},1000:{slidesPerView:4}} }]
			,['.ts-instagram-wrapper', null, { breakpoints: {0:{slidesPerView:1},280:{slidesPerView:2},420:{slidesPerView:3},560:{slidesPerView:4},720:{slidesPerView:5},1000:{slidesPerView:6}} }]
			,['.ts-twitter-slider', '.items', { effect: 'fade', fadeEffect: {crossFade: true}, breakpoints: {0:{slidesPerView:1}} }]
			,['.ts-testimonial-wrapper', '.items', { breakpoints: {0:{slidesPerView:1},600:{slidesPerView:2},900:{slidesPerView:3}} }]
			,['.ts-portfolio-wrapper.ts-slider', '.portfolio-wrapper-content', { breakpoints: {0:{slidesPerView:1},600:{slidesPerView:2},1020:{slidesPerView:3}} }]
			,['.ts-blogs-widget-wrapper', null, { spaceBetween: 10, breakpoints: {0:{slidesPerView:1}} }]
			,['.ts-recent-comments-widget-wrapper', null, { spaceBetween: 10, breakpoints: {0:{slidesPerView:1}} }]
			,['.ts-blogs-wrapper .thumbnail.gallery', 'figure', { effect: 'fade', fadeEffect: {crossFade: true}, spaceBetween: 10, breakpoints:{0:{slidesPerView:1}}, simulateTouch: false, allowTouchMove: false, autoplay: true }]
		];
		
		$.each(data, function(index, value){
			carousel.run( value, $ );
		});
	}
	
	run( data, $ ){
		$(data[0]).each(function( index ){
			if( ! $(this).hasClass('ts-slider') || $(this).hasClass('generated-slider') ){
				return;
			}

			var wrapper	= $(this);
			if( typeof data[1] != 'undefined' && data[1] != null ){
				var swiper = wrapper.find( data[1] );
			} else {
				var swiper = wrapper;
			}

			if( swiper.find('> *').length <= 1 ){
				wrapper.removeClass('loading');
				wrapper.find('.loading').removeClass('loading');

				return;
			}

			var unique_class 		= 'swiper-'+ Math.floor( Math.random() * 10000 ) +'-'+ index;
			var show_nav 			= typeof wrapper.attr('data-nav') != 'undefined' && wrapper.attr('data-nav') == 1?true:false;
			var show_dots 			= typeof wrapper.attr('data-dots') != 'undefined' && wrapper.attr('data-dots') == 1?true:false;
			var auto_play	 		= typeof wrapper.attr('data-autoplay') != 'undefined' && wrapper.attr('data-autoplay') == 1?true:false;
			var columns 			= typeof wrapper.attr('data-columns') != 'undefined'?parseInt(wrapper.attr('data-columns')):5;
			var disable_responsive 	= typeof wrapper.attr('data-disable_responsive') != 'undefined' && wrapper.attr('data-disable_responsive') == 1?true:false;

			wrapper.addClass('generated-slider');
			swiper.addClass('swiper ' + unique_class);
			swiper.find('> *').addClass('swiper-slide');		
			swiper.wrapInner('<div class="swiper-wrapper"></div>');

			var slider_options = {
				loop: true
				,spaceBetween: 0
				,pauseOnMouseEnter: true
				,breakpointsBase: 'container'
				,on: {
					init: function() {
						wrapper.removeClass('loading');
						wrapper.find('.loading').removeClass('loading');
					}
				}
			};

			/* RTL */
			if( $('body').hasClass('rtl') ){
				swiper.attr( 'dir', 'rtl' );
			}

			/* Navigation */
			if( show_nav ){
				swiper.append('<div class="swiper-button-prev"></div><div class="swiper-button-next"></div>');
			
				slider_options.navigation = {
					nextEl: '.swiper-button-next'
					,prevEl: '.swiper-button-prev'
				};
			}

			/* Pagination */
			if( show_dots ){
				swiper.append('<div class="swiper-pagination"></div>');

				slider_options.pagination = {
					el: '.swiper-pagination'
					,clickable: true
				};
			}
			
			/* Autoplay */
			if( auto_play ){
				slider_options.autoplay = {
					delay: 4000
					,disableOnInteraction: false
    				,pauseOnMouseEnter: true
				};
			}

			if( typeof data[2] != 'undefined' && data[2] != null ){
				$.extend( slider_options, data[2] );
				
				if( typeof data[2].breakpoints != 'undefined' ){ /* change breakpoints => add dynamic columns at last */
					switch( data[0] ){
						case '.ts-product-wrapper.grid':
							slider_options.breakpoints[1100] = {slidesPerView:columns};
						break;
						case '.ts-product-wrapper.list':
							slider_options.breakpoints[1100] = {slidesPerView:columns};
						break;
						case '.ts-product-in-category-tab-wrapper.grid, .ts-product-in-product-type-tab-wrapper.grid':
							slider_options.breakpoints[1100] = {slidesPerView:columns};
						break;
						case '.ts-product-in-category-tab-wrapper.list, .ts-product-in-product-type-tab-wrapper.list':
							slider_options.breakpoints[1100] = {slidesPerView:columns};
						break;
						case '.ts-product-deals-wrapper.grid':
							slider_options.breakpoints[1100] = {slidesPerView:columns};
						break;
						case '.ts-product-deals-wrapper.list':
							slider_options.breakpoints[1100] = {slidesPerView:columns};
						break;
						case '.ts-blogs-wrapper':
							slider_options.breakpoints[1000] = {slidesPerView:columns};
						break;
						case '.ts-product-category-wrapper.style-1':
							slider_options.breakpoints[1200] = {slidesPerView:columns};
						break;
						case '.ts-product-category-wrapper.style-2':
							slider_options.breakpoints[1200] = {slidesPerView:columns};
						break;
						case '.ts-product-category-wrapper.style-3':
							slider_options.breakpoints[1200] = {slidesPerView:columns};
						break;
						case '.ts-product-category-wrapper.show-icon':
							slider_options.breakpoints[1200] = {slidesPerView:columns};
						break;
						case '.ts-product-brand-wrapper':
							slider_options.breakpoints[1100] = {slidesPerView:columns};
						break;
						case '.ts-team-members':
							slider_options.breakpoints[1000] = {slidesPerView:columns};
						break;
						case '.ts-testimonial-wrapper':
							slider_options.breakpoints[1200] = {slidesPerView:columns};
						break;
						case '.ts-instagram-wrapper':
							slider_options.breakpoints[1000] = {slidesPerView:columns};
						break;
						case '.ts-portfolio-wrapper':
							slider_options.breakpoints[1200] = {slidesPerView:columns};
						break;
						default:
					}
				}
			}
			
			if( wrapper.hasClass('use-logo-setting') ){ /* Product Brands - Logos */
				var break_point = wrapper.data('break_point');
				var item = wrapper.data('item');

				if( break_point.length > 0 ){
					slider_options.breakpoints = {};
					for( var i = 0; i < break_point.length; i++ ){
						slider_options.breakpoints[ break_point[i] ] = { slidesPerView: item[i] };
					}
				}
			}

			if( disable_responsive ){
				slider_options.breakpoints = {0:{slidesPerView: columns}};
			}
			
			if( columns == 1 ){
				slider_options.breakpoints = {0:{slidesPerView:1}};
			}
			
			if( data[0] == '.ts-blogs-wrapper' ){
				switch( columns ){
					case '1':
						slider_options.breakpoints = {0:{slidesPerView:columns}};
					break;
					case '2':
						slider_options.breakpoints = {0:{slidesPerView:1},700:{slidesPerView:columns}};
					break;
					default:
						slider_options.breakpoints = {0:{slidesPerView:1},700:{slidesPerView:2},1000:{slidesPerView:columns}};
					break;
				}
			}
					
			new Swiper( '.' + unique_class, slider_options );
		});
	}
}

function ts_register_carousel( $scope, $ ){
	var carousel = new TS_Carousel();

	setTimeout(function(){
		carousel.register( $scope, $ );
	}, 10);
}

function ts_register_masonry( $scope, $ ){
	if( typeof $.fn.isotope == 'function' ){
		/* Blog */
		setTimeout(function(){
			$('.ts-blogs-wrapper.ts-masonry .blogs').isotope();
		}, 10);
		
		$('.ts-blogs-wrapper.ts-masonry').removeClass('loading');

		/* Portfolio */
		$('.ts-portfolio-wrapper.ts-masonry').each(function (i, el){
			var loadmore = $(el).data('loadmore');
			/* is Pagination */
			if( loadmore == '2' ){
				var selector = $(el).find('.portfolio-inner');
			} else {
				var selector = $(el).find('.portfolio-wrapper-content');
			}

			selector.isotope({ filter: '*' });
			$(el).removeClass('loading');
		});
	}
}

jQuery(window).on('elementor/frontend/init', function(){
	var elements = ['ts-products', 'ts-product-deals', 'ts-product-categories', 'ts-product-brands', 'ts-blogs'
					,'ts-logos', 'ts-team-members', 'ts-twitter-slider', 'ts-testimonial', 'ts-portfolios'
					,'ts-products-in-category-tabs', 'ts-products-in-product-type-tabs'
					,'wp-widget-ts_products', 'wp-widget-ts_blogs', 'wp-widget-ts_recent_comments', 'wp-widget-ts_instagram'];
	jQuery.each(elements, function(index, name){
		elementorFrontend.hooks.addAction( 'frontend/element_ready/' + name + '.default', ts_register_carousel );
	});
	
	elements = ['ts-blogs', 'ts-portfolios'];
	jQuery.each(elements, function(index, name){
		elementorFrontend.hooks.addAction( 'frontend/element_ready/' + name + '.default', ts_register_masonry );
	});
});
