<?php 
use Elementor\Controls_Manager;

class TS_Elementor_Widget_Form_Filter_Attributes extends TS_Elementor_Widget_Base{
    public function get_name(){
        return 'ts-product-filter-by-attributes';
    }

    public function get_title(){
        return esc_html__( 'TS Product Filter By Attributes', 'themesky' );
    }

    public function get_categories(){
        return array( 'ts-elements', 'woocommerce-elements' );
    }

    public function get_icon(){
        return 'eicon-products';
    }

    protected function register_controls(){
        $this->start_controls_section(
            'section_general'
            ,array(
                'label'     => esc_html__( 'General', 'themesky' )
                ,'tab'      => Controls_Manager::TAB_CONTENT
            )
        );

        $this->add_title_and_style_controls();

        $this->add_control(
            'attributes'
            ,array(
                'label'         => esc_html__( 'Specific attributes', 'themesky' )
                ,'type'         => 'ts_autocomplete_attribute'
                ,'default' 		=> array()
                ,'multiple' 	=> true
				,'label_block' 	=> true
            )
        );

        $this->add_control(
            'style'
            ,array(
                'label' 		=> esc_html__( 'Style', 'themesky' )
                ,'type' 		=> Controls_Manager::SELECT
                ,'default' 		=> 'vertical'
				,'options'		=> array(
                                    'vertical'	    => esc_html__( 'Vertical', 'themesky' )
									,'horizontal'	=> esc_html__( 'Horizontal', 'themesky' )
								)			
                ,'description' 	=> ''
            )
        );
		
		$this->add_control(
            'custom_color'
            ,array(
                'label' 		=> esc_html__( 'Custom Color', 'themesky' )
                ,'type' 		=> Controls_Manager::SELECT
                ,'default' 		=> '0'
				,'options'		=> array(
									'0'		=> esc_html__( 'No', 'themesky' )
									,'1'	=> esc_html__( 'Yes', 'themesky' )
								)			
                ,'description' 	=> ''
            )
        );
		
		$this->add_control(
            'text_color'
            ,array(
                'label'     	=> esc_html__( 'Text Color', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#202020'
				,'condition'	=> array( 'custom_color' => '1' )
				,'selectors'	=> array(
					'{{WRAPPER}} .ts-product-filter-by-attribute' => 'color: {{VALUE}}'
				)
            )
        );
		
		$this->add_control(
            'background_color'
            ,array(
                'label'     	=> esc_html__( 'Background Color', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#ffb91f'
				,'condition'	=> array( 'custom_color' => '1' )
				,'selectors'	=> array(
					'{{WRAPPER}} .ts-product-filter-by-attribute:before' => 'background: {{VALUE}}'
				)
            )
        );
		
		$this->add_control(
            'select_text_color'
            ,array(
                'label'     	=> esc_html__( 'Select Text Color', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#848484'
				,'condition'	=> array( 'custom_color' => '1' )
				,'selectors'	=> array(
					'{{WRAPPER}} .ts-product-filter-by-attribute form select' => 'color: {{VALUE}}'
				)
            )
        );
		
		$this->add_control(
            'select_bg_color'
            ,array(
                'label'     	=> esc_html__( 'Select Background Color', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#ffffff'
				,'condition'	=> array( 'custom_color' => '1' )
				,'selectors'	=> array(
					'{{WRAPPER}} .ts-product-filter-by-attribute form select' => 'background-color: {{VALUE}};border-color: {{VALUE}}'
				)
            )
        );
		
		$this->add_control(
            'button_text_color'
            ,array(
                'label'     	=> esc_html__( 'Button Text Color', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#ffb91f'
				,'condition'	=> array( 'custom_color' => '1' )
				,'selectors'	=> array(
					'{{WRAPPER}} .ts-product-filter-by-attribute > form > input[type="submit"]' => 'color: {{VALUE}}'
				)
            )
        );
		
		$this->add_control(
            'button_bg_color'
            ,array(
                'label'     	=> esc_html__( 'Button Background Color', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#202020'
				,'condition'	=> array( 'custom_color' => '1' )
				,'selectors'	=> array(
					'{{WRAPPER}} .ts-product-filter-by-attribute > form > input[type="submit"]' => 'background: {{VALUE}};border-color: {{VALUE}}'
					,'{{WRAPPER}} .ts-product-filter-by-attribute > form > input[type="submit"]:hover' => 'background:transparent;color: {{VALUE}};'
				)
            )
        );
		
        $this->end_controls_section();

    }

    protected function render(){
        $settings = $this->get_settings_for_display();

        $default = array(
            'title'         => ''
            ,'attributes'   => array()
            ,'style'        => 'vertical'
        );

        $settings = wp_parse_args( $settings, $default );

        extract( $settings );

        ts_form_product_filter_by_attribute( $attributes, $title, $style );
    }
}

$widgets_manager->register_widget_type( new TS_Elementor_Widget_Form_Filter_Attributes() );