<?php
use Elementor\Controls_Manager;

class TS_Elementor_Widget_Banner extends TS_Elementor_Widget_Base{
	public function get_name(){
        return 'ts-banner';
    }
	
	public function get_title(){
        return esc_html__( 'TS Banner', 'themesky' );
    }
	
	public function get_categories(){
        return array( 'ts-elements', 'general' );
    }
	
	public function get_icon(){
		return 'eicon-image';
	}
	
	protected function register_controls(){
		$this->start_controls_section(
            'section_general'
            ,array(
                'label' 	=> esc_html__( 'General', 'themesky' )
                ,'tab'   	=> Controls_Manager::TAB_CONTENT
            )
        );
				
		$this->add_responsive_control(
			'banner_min_height',
			[
				'label' => __( 'Banner Min Height(px)', 'themesky' )
				,'type' => Controls_Manager::SLIDER
				,'range' => [
					'px' => [
						'min' => 0
						,'max' => 1000
					]
				]
				,'devices' => [ 'desktop', 'tablet', 'mobile' ]
				,'desktop_default' => [
					'size' => 0
					,'unit' => 'px'
				]
				,'tablet_default' => [
					'size' => 220
					,'unit' => 'px'
				]
				,'mobile_default' => [
					'size' => 220
					,'unit' => 'px'
				]
				,'selectors' => [
					'{{WRAPPER}} .banner-bg img' => 'min-height: {{SIZE}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
            'img_bg'
            ,array(
                'label' 		=> esc_html__( 'Background Image', 'themesky' )
                ,'type' 		=> Controls_Manager::MEDIA
                ,'default' 		=> array( 'id' => '', 'url' => '' )		
                ,'description' 	=> ''
            )
        );

		$this->add_control(
            'heading_title'
            ,array(
                'label' 		=> esc_html__( 'Heading', 'themesky' )
                ,'type' 		=> Controls_Manager::TEXT
                ,'default' 		=> ''		
                ,'description' 	=> ''
            )
        );
		
		$this->add_responsive_control(
			'heading_size',
			[
				'label' => __( 'Font Size Heading(px)', 'themesky' )
				,'type' => Controls_Manager::SLIDER
				,'range' => [
					'px' => [
						'min' => 0
						,'max' => 100
					]
				]
				,'devices' => [ 'desktop', 'tablet', 'mobile' ]
				,'desktop_default' => [
					'size' => 30
					,'unit' => 'px'
				]
				,'tablet_default' => [
					'size' => 25
					,'unit' => 'px'
				]
				,'mobile_default' => [
					'size' => 25
					,'unit' => 'px'
				]
				,'selectors' => [
					'{{WRAPPER}} .box-content h2' => 'font-size: {{SIZE}}{{UNIT}};'
				]
			]
		);
		
		$this->add_responsive_control(
			'heading_max_width',
			[
				'label' => __( 'Content Max Width(%)', 'themesky' )
				,'type' => Controls_Manager::SLIDER
				,'range' => [
					'px' => [
						'min' => 0
						,'max' => 100
					]
				]
				,'devices' => [ 'desktop', 'tablet', 'mobile' ]
				,'desktop_default' => [
					'size' => 100
					,'unit' => '%'
				]
				,'tablet_default' => [
					'size' => 100
					,'unit' => '%'
				]
				,'mobile_default' => [
					'size' => 100
					,'unit' => '%'
				]
				,'selectors' => [
					'{{WRAPPER}} .box-content > div' => 'max-width: {{SIZE}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
            'heading_color'
            ,array(
                'label'     	=> esc_html__( 'Heading Color', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#ffffff'
				,'selectors'	=> array(
					'{{WRAPPER}} .box-content h2' => 'color: {{VALUE}}'
				)
            )
        );	
		
		$this->add_control(
            'description'
            ,array(
                'label' 		=> esc_html__( 'Description', 'themesky' )
                ,'type' 		=> Controls_Manager::WYSIWYG
                ,'default' 		=> ''		
                ,'description' 	=> ''
            )
        );
		
		$this->add_responsive_control(
			'description_size',
			[
				'label' => __( 'Font Size Description(px)', 'themesky' )
				,'type' => Controls_Manager::SLIDER
				,'range' => [
					'px' => [
						'min' => 0
						,'max' => 100
					]
				]
				,'devices' => [ 'desktop', 'tablet', 'mobile' ]
				,'desktop_default' => [
					'size' => 16
					,'unit' => 'px'
				]
				,'tablet_default' => [
					'size' => 14
					,'unit' => 'px'
				]
				,'mobile_default' => [
					'size' => 14
					,'unit' => 'px'
				]
				,'selectors' => [
					'{{WRAPPER}} .box-content .description' => 'font-size: {{SIZE}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
            'description_color'
            ,array(
                'label'     	=> esc_html__( 'Description Color', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#ffffff'
				,'selectors'	=> array(
					'{{WRAPPER}} .box-content .description' => 'color: {{VALUE}}'
				)
            )
        );
		
		$this->add_control(
            'description_position'
            ,array(
                'label' 		=> esc_html__( 'Description Position', 'themesky' )
                ,'type' 		=> Controls_Manager::SELECT
                ,'default' 		=> 'bottom'
				,'options'		=> array(
									'top'			=> esc_html__( 'Top', 'themesky' )
									,'bottom'		=> esc_html__( 'Bottom', 'themesky' )
								)			
                ,'description' 	=> ''
            )
        );
		
		$this->add_control(
            'text_position'
            ,array(
                'label' 		=> esc_html__( 'Banner Text Position', 'themesky' )
                ,'type' 		=> Controls_Manager::SELECT
                ,'default' 		=> 'left-top'
				,'options'		=> array(
									'left-top'			=> esc_html__( 'Left Top', 'themesky' )
									,'left-bottom'		=> esc_html__( 'Left Bottom', 'themesky' )
									,'left-center'		=> esc_html__( 'Left Center', 'themesky' )
									,'right-top'		=> esc_html__( 'Right Top', 'themesky' )
									,'right-bottom'		=> esc_html__( 'Right Bottom', 'themesky' )
									,'right-center'		=> esc_html__( 'Right Center', 'themesky' )
									,'center-top'		=> esc_html__( 'Center Top', 'themesky' )
									,'center-bottom'	=> esc_html__( 'Center Bottom', 'themesky' )
									,'center-center'	=> esc_html__( 'Center Center', 'themesky' )
								)			
                ,'description' 	=> ''
            )
        );
		
		$this->add_control(
            'link'
            ,array(
                'label'     	=> esc_html__( 'Link', 'themesky' )
                ,'type'     	=> Controls_Manager::URL
				,'default'  	=> array( 'url' => '', 'is_external' => true, 'nofollow' => true )
				,'show_external'=> true
            )
        );
		
		$this->add_control(
            'has_border_radius'
            ,array(
                'label' 		=> esc_html__( 'Has Border Radius', 'themesky' )
                ,'type' 		=> Controls_Manager::SELECT
                ,'default' 		=> '0'
				,'options'		=> array(
									'0'				=> esc_html__( 'No', 'themesky' )
									,'1'			=> esc_html__( 'Yes', 'themesky' )
									
								)			
                ,'description' 	=> ''
            )
        );
		
		$this->add_control(
            'button_style'
            ,array(
                'label' 		=> esc_html__( 'Button Style', 'themesky' )
                ,'type' 		=> Controls_Manager::SELECT
                ,'default' 		=> 'nobtn'
				,'options'		=> array(
									'nobtn'					=> esc_html__( 'No Button', 'themesky' )
									,'button-default'		=> esc_html__( 'Button Default', 'themesky' )
									,'button-text'			=> esc_html__( 'Button Text', 'themesky' )
									
								)			
                ,'description' 	=> ''
            )
        );
		
		$this->add_control(
            'button_text'
            ,array(
                'label' 		=> esc_html__( 'Button Text', 'themesky' )
                ,'type' 		=> Controls_Manager::TEXT
                ,'default' 		=> 'Shop Now'		
                ,'description' 	=> ''
				,'condition'	=> array( 'button_style' => array( 'button-default', 'button-text' ) )
            )
        );
		
		$this->add_responsive_control(
			'button_size',
			[
				'label' => __( 'Font Size Button', 'themesky' )
				,'type' => Controls_Manager::SLIDER
				,'condition'	=> array( 'button_style' => array( 'button-default', 'button-text' ) )
				,'range' => [
					'px' => [
						'min' => 0
						,'max' => 100
					]
				]
				,'devices' => [ 'desktop', 'tablet', 'mobile' ]
				,'desktop_default' => [
					'size' => 14
					,'unit' => 'px'
				]
				,'tablet_default' => [
					'size' => 14
					,'unit' => 'px'
				]
				,'mobile_default' => [
					'size' => 14
					,'unit' => 'px'
				]
				,'selectors' => [
					'{{WRAPPER}} .box-content .ts-banner-button .button' => 'font-size: {{SIZE}}{{UNIT}};'
				]
			]
		);
		
		$this->add_control(
            'button_background_color'
            ,array(
                'label'     	=> esc_html__( 'Button Background Color', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#ffb91f'
				,'selectors'	=> array(
					'{{WRAPPER}} .button' => 'background-color: {{VALUE}}; border-color: {{VALUE}}'
				)
				,'condition'	=> array( 'button_style' => 'button-default' )
            )
        );
		
		$this->add_control(
            'button_text_color'
            ,array(
                'label'     	=> esc_html__( 'Button Text Color', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#202020'
				,'selectors'	=> array(
					'{{WRAPPER}} .button' => 'color: {{VALUE}}'
				)
				,'condition'	=> array( 'button_style' => array( 'button-default', 'button-text' ) )
            )
        );
		
		$this->add_control(
            'button_background_color_hover'
            ,array(
                'label'     	=> esc_html__( 'Button Background Color Hover', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#ffffff'
				,'selectors'	=> array(
					'{{WRAPPER}}:hover .button' => 'background-color: {{VALUE}}; border-color: {{VALUE}}'
				)
				,'condition'	=> array( 'button_style' => 'button-default' )
            )
        );
		
		$this->add_control(
            'button_text_color_hover'
            ,array(
                'label'     	=> esc_html__( 'Button Text Color Hover', 'themesky' )
                ,'type'     	=> Controls_Manager::COLOR
				,'default'  	=> '#ffb91f'
				,'selectors'	=> array(
					'{{WRAPPER}}:hover .button' => 'color: {{VALUE}}'
				)
				,'condition'	=> array( 'button_style' => array( 'button-default', 'button-text' ) )
            )
        );

		$this->add_control(
            'style_effect'
            ,array(
                'label' 		=> esc_html__( 'Style Effect', 'themesky' )
                ,'type' 		=> Controls_Manager::SELECT
                ,'default' 		=> 'eff-zoom-in'
				,'options'		=> array(									
									'eff-zoom-in'				=> esc_html__('Zoom In', 'themesky')
									,'eff-zoom-out' 			=> esc_html__('Zoom Out', 'themesky')
									,'eff-zoom-rotate' 			=> esc_html__('Rotate and zoom in', 'themesky')
									,'eff-flash' 				=> esc_html__('Flash', 'themesky')
									,'eff-line' 				=> esc_html__('Line', 'themesky')
									,'eff-overlay' 				=> esc_html__('Overlay', 'themesky')
									,'no-effect' 				=> esc_html__('None', 'themesky')
								)			
                ,'description' 	=> ''
            )
        );
		
		$this->end_controls_section();
	}
	
	protected function render(){
		$settings = $this->get_settings_for_display();
		
		$default = array(
			'img_bg'							=> array( 'id' => '', 'url' => '' )
			,'banner_min_height'				=> '0'
			,'heading_title'					=> ''
			,'heading_size'						=> '30'
			,'heading_color'					=> '#ffffff'
			,'description'						=> ''
			,'description_size'					=> '16'
			,'description_color'				=> '#ffffff'
			,'description_position'				=> 'bottom'
			,'text_position'					=> 'left-top'
			,'has_border_radius'				=> '0'
			,'button_style'						=> 'nobtn'
			,'button_text'						=> 'Shop Now'
			,'button_size'						=> '14'
			,'button_background_color'			=> '#ffb91f'
			,'button_text_color'				=> '#202020'
			,'button_background_color_hover'	=> '#ffffff'
			,'button_text_color_hover'			=> '#ffb91f'
			,'link' 							=> array( 'url' => '', 'is_external' => true, 'nofollow' => true )
			,'style_effect'						=> 'eff-zoom-in'
		);
		
		$settings = wp_parse_args( $settings, $default );
		
		extract( $settings );
		
		$link_attr = $this->generate_link_attributes( $link );
		
		$classes = array();
		$classes[] = $style_effect;
		$classes[] = $button_style;
		$classes[] = 'description-'.$description_position;
		$classes[] = $text_position;
		
		if( $has_border_radius ){
			$classes[] = 'has-border-radius';
		}
		
		$allowed_html = array(
			'br'		=> array()
			,'h1'			=> array(
				'class'		=> array()
				,'style'	=> array()
			)
			,'h2'			=> array(
				'class'		=> array()
				,'style'	=> array()
			)
			,'h3'			=> array(
				'class'		=> array()
				,'style'	=> array()
			)
			,'h4'			=> array(
				'class'		=> array()
				,'style'	=> array()
			)
			,'h5'			=> array(
				'class'		=> array()
				,'style'	=> array()
			)
			,'h6'			=> array(
				'class'		=> array()
				,'style'	=> array()
			)
			,'p'			=> array(
				'class'		=> array()
				,'style'	=> array()
			)
			,'strong'	=> array(
				'class'		=> array()
				,'style'	=> array()
			)
			,'span'		=> array(
				'class'		=> array()
				,'style'	=> array()
			)
			,'img'		=> array(
				'src'		=> array()
				,'alt'		=> array()
				,'class'	=> array()
				,'width'	=> array()
				,'height'	=> array()
				,'loading'	=> array()
				,'srcset'	=> array()
				,'sizes'	=> array()
			)
			,'div'	=> array(
				'class'		=> array()
				,'style'	=> array()
			)
		);
		?>
		<div class="ts-banner <?php echo esc_attr( implode(' ', $classes) ); ?>">
			<div class="banner-wrapper">
			
				<?php if( $link_attr ): ?>
				<a class="banner-link" <?php echo implode(' ', $link_attr); ?>></a>
				<?php endif;?>
					
				<div class="banner-bg">
					<div class="bg-content">
					<?php echo wp_get_attachment_image($img_bg['id'], 'full', 0, array('class'=>'img')); ?>
					</div>
				</div>
							
				<div class="box-content">
					<div>
					
						<?php if( $heading_title ): ?>				
						<h2><?php echo esc_html($heading_title) ?></h2>
						<?php endif; ?>
						
						<?php if( $description ): ?>				
						<div class="description"><?php echo wp_kses($description, $allowed_html); ?></div>
						<?php endif; ?>
						
						<?php if( $button_text ):?>
						<div class="ts-banner-button">
							<a class="button" <?php echo implode(' ', $link_attr); ?>><?php echo esc_html($button_text) ?></a>
						</div>
						<?php endif; ?>
						
					</div>
				</div>
				
			</div>
		</div>
		<?php
	}
}

$widgets_manager->register_widget_type( new TS_Elementor_Widget_Banner() );