<?php

/**
 * @package Unlimited Elements
 * @author UniteCMS http://unitecms.net
 * @copyright Copyright (c) 2016 UniteCMS
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

defined('UNLIMITED_ELEMENTS_INC') or die('Restricted access');

class UCAdminNoticeRating extends UCAdminNoticeAbstract{

	protected $start = 864000; // offset in seconds from the plugin installation - 10 days
	protected $duration = 864000; // offset in seconds from the first display - 10 days

	
	/**
	 * init the notice
	 */
	public function init(){
		
		if(GlobalsUnlimitedElements::$adminNoticesDebug == true)
			$this->setDebugMode();
	}
	
	/**
	 * get the notice identifier
	 */
	public function getId(){

		return 'rating';
	}

	/**
	 * get the notice html
	 */
	public function getHtml(){
		
		$heading = __('Could you please do us a BIG favor?', 'unlimited-elements-for-elementor');
		$content = __('Leave a 5-start rating on WordPress. Help us spread the word and boost our motivation.', 'unlimited-elements-for-elementor');

		$rateText = __('Ok, you deserve it', 'unlimited-elements-for-elementor');
		$rateUrl = 'https://wordpress.org/plugins/unlimited-elements-for-elementor/#reviews';
		$rateVariant = UCAdminNoticeBuilder::ACTION_VARIANT_PRIMARY;
		$rateTarget = '_blank';

		$postponeText = __('Nope, maybe later', 'unlimited-elements-for-elementor');
		$postponeDuration = 604800; // 7 days in seconds

		$dismissText = __('I already did', 'unlimited-elements-for-elementor');
		
		$objBuilder = $this->createBuilder();
		$objBuilder->dismissible();
		
		$objBuilder->withHeading($heading);
		$objBuilder->withContent($content);
		$objBuilder->withLinkAction($rateText, $rateUrl, $rateVariant, $rateTarget);
		$objBuilder->withPostponeAction($postponeText, $postponeDuration);
		$objBuilder->withDismissAction($dismissText);
		
		$htmlNotice = $objBuilder->build();
		
		
		return($htmlNotice);
	}

}
