<?php

/**
 * @package Unlimited Elements
 * @author UniteCMS http://unitecms.net
 * @copyright Copyright (c) 2016 UniteCMS
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */

defined('UNLIMITED_ELEMENTS_INC') or die('Restricted access');

class UCAdminNoticeDoubly extends UCAdminNoticeAbstract{

	protected $duration = 172800; // offset in seconds from the first display - 2 days
	
	
	/**
	 * init the notice
	 */
	public function init(){
		
		if(GlobalsUnlimitedElements::$adminNoticesDebug == true)
			$this->setDebugMode();
		
	}
	
	
	/**
	 * get the notice identifier
	 */
	public function getId(){

		return 'doubly';
	}

	/**
	 * get the notice html
	 */
	public function getHtml(){

		$heading = __('Live Copy Paste from Unlimited Elements', 'unlimited-elements-for-elementor');
		$content = __('Did you know that now you can copy fully designed sections from Unlimited Elements to your website for FREE? <br /> If you want to try then install our new plugin called Doubly. <br />', 'unlimited-elements-for-elementor');

		$installText = __('Install Doubly Now', 'unlimited-elements-for-elementor');
		$installUrl = UniteFunctionsWPUC::getInstallPluginLink('doubly');
		$installUrl = UniteFunctionsUC::addUrlParams($installUrl, array('uc_dismiss_notice' => $this->getId()));
		
		$objBuilder = $this->createBuilder();
		
		$objBuilder->dismissible();
		$objBuilder->color(UCAdminNoticeBuilder::COLOR_DOUBLY);
		$objBuilder->withHeading($heading);
		$objBuilder->withContent($content);
		$objBuilder->withLinkAction($installText, $installUrl);
		
		$htmlNotice = $objBuilder->build();
		
		return $htmlNotice;
	}

}
